<?php
session_start();
require '../conexao.php'; // Inclui o arquivo de conexão

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Verifica se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

$jogador = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'];

// Verifica se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $quantidade = (int)$_POST['quantidade'];
    $preco = (float)$_POST['preco'];

    // Validação básica
    if ($quantidade <= 0 || $preco <= 0) {
        $_SESSION['msg'] = "Por favor, preencha todos os campos corretamente.";
        header("Location: vender_fichas.php");
        exit();
    }
// xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    // Verifica se o jogador tem fichas suficientes
    try {
        $pdo->beginTransaction();

        // Conta as fichas disponíveis do jogador (situacao = '1')
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM fichaspersonagens WHERE jogador = ? AND situacao = '1'");
        $stmt->execute([$user_name]);
        $fichas_disponiveis = $stmt->fetchColumn();

        error_log("Fichas disponíveis para $user_name: $fichas_disponiveis");

        if ($fichas_disponiveis < $quantidade) {
            $_SESSION['msg'] = "Fichas insuficientes. Você tem $fichas_disponiveis fichas disponíveis e tentou vender $quantidade.";
            header("Location: vender_fichas.php");
            exit();
        }



// xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
// Verifica se há ordens de compra com valor igual ou maior ao preço informado no input
try {
    // Prepara a consulta SQL para buscar ordens de compra com valor igual ou maior ao preço informado
    $stmt = $pdo->prepare("
        SELECT id, quantidade, valor, user, dataehora 
        FROM ordens_compra 
        WHERE CAST(valor AS DECIMAL(10,2)) >= CAST(? AS DECIMAL(10,2)) 
        AND user != ?
        ORDER BY valor DESC, dataehora ASC
    ");
    // Executa a consulta, passando o preço e o nome do usuário como parâmetros
    $stmt->execute([$preco, $user_name]);
    // Busca todos os resultados da consulta e armazena em $ordens_compra
    $ordens_compra = $stmt->fetchAll(PDO::FETCH_ASSOC); // Busca todos os resultados

    // Log para depuração: exibe o número de ordens de compra encontradas
    error_log("Número de ordens de compra encontradas: " . count($ordens_compra));

    // Verifica se há ordens de compra disponíveis
    if (count($ordens_compra) > 0) {
        // Define uma mensagem na sessão informando que há ordens de compra disponíveis
    //    $_SESSION['msg'] = "Há ordens de compra disponíveis para o valor informado ou maior.";

        // Exibe os dados das ordens de compra em uma tabela HTML
        echo "<h3>Ordens de Compra Disponíveis:</h3>";
        echo "<table border='1'>";
        echo "<tr>
                <th>Quantidade</th>
                <th>Valor (R$)</th>
                <th>Usuário</th>
                <th>Data e Hora</th>
              </tr>";

        // Itera sobre as ordens de compra encontradas
        foreach ($ordens_compra as $ordem) {
            echo "<tr>";
            // Exibe a quantidade de fichas da ordem de compra
            echo "<td>" . htmlspecialchars($ordem['quantidade']) . "</td>";
            // Exibe o valor unitário da ordem de compra
            echo "<td>" . htmlspecialchars($ordem['valor']) . "</td>";
            // Exibe o nome do usuário que criou a ordem de compra
            echo "<td>" . htmlspecialchars($ordem['user']) . "</td>";
            // Exibe a data e hora da criação da ordem de compra
            echo "<td>" . htmlspecialchars($ordem['dataehora']) . "</td>";
            echo "</tr>";
        }

        echo "</table>";

// xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        // Compara a quantidade de fichas vendidas com as ordens de compra
        $fichas_restantes = $quantidade; // Quantidade de fichas que ainda precisam ser vendidas
        $transacoes = []; // Armazena as transações que serão realizadas

        // Itera sobre as ordens de compra para processar as transações
        foreach ($ordens_compra as $ordem) {
            // Se não há mais fichas para vender, interrompe o loop
            if ($fichas_restantes <= 0) {
                break; // Todas as fichas já foram vendidas
            }

            // Obtém a quantidade de fichas solicitadas na ordem de compra
            $quantidade_ordem = (int)$ordem['quantidade'];
            // Calcula a quantidade de fichas que serão vendidas para esta ordem
            $quantidade_vendida = min($quantidade_ordem, $fichas_restantes); // Quantidade que será vendida para esta ordem

            // Armazena os detalhes da transação no array $transacoes
            $transacoes[] = [
                'id_ordem' => $ordem['id'], // ID da ordem de compra
                'quantidade' => $quantidade_vendida, // Quantidade de fichas vendidas
                'valor' => $ordem['valor'], // Valor unitário da ordem de compra
                'user' => $ordem['user'] // Usuário que criou a ordem de compra
            ];

            // Atualiza a quantidade de fichas restantes
            $fichas_restantes -= $quantidade_vendida; // Atualiza a quantidade de fichas restantes






            
        }


// xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
            // Exibe as transações realizadas
echo "<h4>Transações Realizadas:</h4>";
echo "<table border='1'>";
echo "<tr>
        <th>ID da Ordem</th>
        <th>Quantidade Vendida</th>
        <th>Quantidade Pendente</th>
        <th>Valor Unitário (R$)</th>
        <th>Total Obtido (R$)</th>
        <th>Usuário</th>
      </tr>";

$total_ganho = 0; // Variável para armazenar o valor total ganho

foreach ($transacoes as $transacao) {
    // Calcula o total obtido na transação (quantidade x valor)
    $total_obtido = $transacao['quantidade'] * $transacao['valor'];
    $total_ganho += $total_obtido; // Acumula o valor total ganho

    // Busca a quantidade original da ordem de compra
    $stmt = $pdo->prepare("SELECT quantidade FROM ordens_compra WHERE id = ?");
    $stmt->execute([$transacao['id_ordem']]);
    $quantidade_original = $stmt->fetchColumn();

    // Calcula e mostrar a quantidade pendente
    $quantidade_pendente = $quantidade_original - $transacao['quantidade'];

    echo "<tr>";
    echo "<td>" . htmlspecialchars($transacao['id_ordem']) . "</td>"; // ID da ordem
    echo "<td>" . htmlspecialchars($transacao['quantidade']) . "</td>"; // Quantidade vendida
    echo "<td>" . htmlspecialchars($quantidade_pendente) . "</td>"; // Quantidade pendente
    echo "<td>" . htmlspecialchars($transacao['valor']) . "</td>"; // Valor unitário
    echo "<td>" . htmlspecialchars(number_format($total_obtido, 2, ',', '.')) . "</td>"; // Total obtido
    echo "<td>" . htmlspecialchars($transacao['user']) . "</td>"; // Usuário
    echo "</tr>";
}

echo "</table>";



// xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
// Exibe o valor total ganho
echo "<h4>Valor Total Ganho:</h4>";
echo "<p>R$ " . number_format($total_ganho, 2, ',', '.') . "</p>";
      




        // Exibe o resultado da comparação
        echo "<h3>Resultado da Comparação:</h3>";
        echo "<p>Quantidade de fichas vendidas: $quantidade</p>";
        echo "<p>Quantidade de fichas restantes: $fichas_restantes</p>";

        // Exibe as transações realizadas em uma tabela HTML
    // Exibe as transações realizadas
echo "<h4>Transações Realizadas:</h4>";
echo "<table border='1'>";
echo "<tr>
        <th>ID da Ordem</th>
        <th>Quantidade</th>
        <th>Valor Unitário (R$)</th>
        <th>Total Obtido (R$)</th>
        <th>Usuário</th>
      </tr>";

foreach ($transacoes as $transacao) {
    // Calcula o total obtido na transação (quantidade x valor)
    $total_obtido = $transacao['quantidade'] * $transacao['valor'];

    echo "<tr>";
    echo "<td>" . htmlspecialchars($transacao['id_ordem']) . "</td>"; // ID da ordem
    echo "<td>" . htmlspecialchars($transacao['quantidade']) . "</td>"; // Quantidade vendida
    echo "<td>" . htmlspecialchars($transacao['valor']) . "</td>"; // Valor unitário
    echo "<td>" . htmlspecialchars(number_format($total_obtido, 2, ',', '.')) . "</td>"; // Total obtido
    echo "<td>" . htmlspecialchars($transacao['user']) . "</td>"; // Usuário
    echo "</tr>";
}

echo "</table>";




   $valor_total = $transacao['quantidade'] * $transacao['valor'];

    // Prepara a descrição da transação
    $referencia = "{$transacao['quantidade']} fichas vendidas para a ordem de compra {$transacao['id_ordem']} por R$ {$transacao['valor']} cada, totalizando R$ $valor_total.";

    // xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        // Verifica se há ordens de compra com quantidades pendentes
        $ordens_pendentes = [];

        foreach ($transacoes as $transacao) {
            // Busca a quantidade original da ordem de compra
            $stmt = $pdo->prepare("SELECT quantidade FROM ordens_compra WHERE id = ?");
         $stmt->execute([$transacao['id_ordem']]);
         $quantidade_original = $stmt->fetchColumn();

            // Calcula a quantidade pendente
            $quantidade_pendente = $quantidade_original - $transacao['quantidade'];

            // Se houver quantidade pendente, adiciona aos dados da ordem pendente
         if ($quantidade_pendente > 0) {
            $ordens_pendentes[] = [
            'id_ordem' => $transacao['id_ordem'],
            'quantidade_pendente' => $quantidade_pendente,
            'valor' => $transacao['valor'],
            'user' => $transacao['user']
        ];
    }
}

            // Se houver ordens pendentes, exibe os dados
            if (count($ordens_pendentes) > 0) {
                echo "<h4>Ordens de Compra com Quantidades Pendentes:</h4>";
                echo "<table border='1'>";
                echo "<tr>
                        <th>ID da Ordem</th>
                        <th>Quantidade Pendente</th>
                        <th>Valor Unitário (R$)</th>
                        <th>Usuário</th>
                    </tr>";

                foreach ($ordens_pendentes as $ordem_pendente) {
                    echo "<tr>";
                    echo "<td>" . htmlspecialchars($ordem_pendente['id_ordem']) . "</td>"; // ID da ordem
                    echo "<td>" . htmlspecialchars($ordem_pendente['quantidade_pendente']) . "</td>"; // Quantidade pendente
                    echo "<td>" . htmlspecialchars($ordem_pendente['valor']) . "</td>"; // Valor unitário
                    echo "<td>" . htmlspecialchars($ordem_pendente['user']) . "</td>"; // Usuário
                    echo "</tr>";
                }

                echo "</table>";
                echo "<p>Aqui estão as ordens de compra com quantidades pendentes.</p>";
            } else {
                echo "<p>Não há ordens de compra com quantidades pendentes.</p>";
            }






// xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
// Verifica se sobrou alguma quantidade de fichas



if ($fichas_restantes > 0) {
    echo "<h4>Fichas que Sobraram:</h4>";
    echo "<table border='1'>";
    echo "<tr>
            <th>ID da Ordem</th>
            <th>Quantidade Pendente</th>
            <th>Valor Unitário (R$)</th>
            <th>Usuário</th>
          </tr>";

    // Itera sobre as transações para encontrar as ordens com fichas pendentes
    foreach ($transacoes as $transacao) {
        // Busca a quantidade original da ordem de compra
        $stmt = $pdo->prepare("SELECT quantidade FROM ordens_compra WHERE id = ?");
        $stmt->execute([$transacao['id_ordem']]);
        $quantidade_original = $stmt->fetchColumn();

        // Se não encontrou a quantidade original, continua o loop
        if ($quantidade_original === false) {
            continue;
        }

        // Calcula a quantidade pendente
        $quantidade_pendente = $quantidade_original - $transacao['quantidade'];

        // Se houver quantidade pendente, exibe os dados da ordem
        if ($quantidade_pendente > 0) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($transacao['id_ordem']) . "</td>"; // ID da ordem
            echo "<td>" . htmlspecialchars($quantidade_pendente) . "</td>"; // Quantidade pendente
            echo "<td>" . htmlspecialchars($transacao['valor']) . "</td>"; // Valor unitário
            echo "<td>" . htmlspecialchars($transacao['user']) . "</td>"; // Usuário
            echo "</tr>";
        }
    }

    echo "</table>";
    echo "<p>Sobrou $fichas_restantes ficha(s).</p>";

// xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
// Mudar situação das fichas que sobraram, pra vendendo
// **Verifica se já há uma transação ativa antes de iniciar uma nova**
if (!$pdo->inTransaction()) {
    $pdo->beginTransaction();
}

$jogador_logado = $_SESSION['user_name'];
$valor = $preco;

try {
    $sql_cancelar = "
        UPDATE fichaspersonagens 
        SET situacao = 'vendendo', preco = ?
        WHERE jogador = ? AND situacao = '1' 
    LIMIT $fichas_restantes
    ";
    $stmt_cancelar = $pdo->prepare($sql_cancelar);
    $stmt_cancelar->execute([$preco, $jogador_logado]);

    if ($stmt_cancelar->rowCount() > 0) {
        $pdo->commit();
        $_SESSION['msg'] = "Fichas que sobraram, foram listadas para venda!";
    } else {
        $pdo->rollBack();
        $_SESSION['msg'] = "Erro: Nenhuma ficha encontrada para listar para venda.";

        echo $jogador_logado;
    }
} catch (PDOException $e) {
    $pdo->rollBack();
    $_SESSION['msg'] = "Erro no banco de dados: " . $e->getMessage();
}

// Exibir a mensagem de erro ou sucesso
if (isset($_SESSION['msg'])) {
    echo "<p>" . $_SESSION['msg'] . "</p>";
    unset($_SESSION['msg']); // Remove a mensagem após exibir
}
 
} else {
    echo "<p>Todas as fichas foram vendidas.</p>";
  //  exit(); // Se todas foram vendidas, sai do script
}






// xxxxxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
// Inserção na mempool



// Ativar exibição de erros
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Verificar conexão com o banco de dados
try {
    $pdo->query("SELECT 1");
    error_log("Conexão com o banco de dados funcionando!");
} catch (PDOException $e) {
    error_log("Erro na conexão com o banco de dados: " . $e->getMessage());
    die("Erro na conexão com o banco de dados.");
}

// Verificar dados
$valor = $total_ganho;
error_log("Dados para inserção na mempool:");
error_log("Destinatário: " . $_SESSION['user_wallet']);
error_log("Valor: " . $valor);

// Inserção na mempool

// Ativar exibição de erros
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Dados de exemplo (substitua pelos seus dados reais)
$wallet = $_SESSION['user_wallet']; // Exemplo de carteira
$valor = $total_ganho; // Exemplo de valor

try {
    // Verifica se já há uma transação ativa
    if ($pdo->inTransaction()) {
        $pdo->commit(); // Finaliza a transação ativa
    }

    // Inicia uma nova transação
    $pdo->beginTransaction();

    // Query de inserção
    $query = "
        INSERT INTO mempool (destinatario, remetente, dataehora, valor, referencia)
        VALUES (:destinatario, :remetente, NOW(), :valor, :referencia)
    ";

    // Parâmetros
    $params = [
        ':destinatario' => $wallet,
        ':remetente' => 'Ficha vendida para ordem de compra',
        ':valor' => $valor,
        ':referencia' => 'Venda de ficha para ordem/s de compra/s'
    ];

    // Prepara e executa a query
    $stmt = $pdo->prepare($query);
    $stmt->execute($params);
    //pegar o id inserido na mempool pra dps mandar pro sistema
$id_transacao_mempool = $pdo->lastInsertId();
// Agora você pode usar $id_transacao_mempool no seu código
//echo "ID da transação na mempool: $id_transacao_mempool";
    // Confirma a transação
    $pdo->commit();

    // Mensagem de sucesso
    echo "Inserção na tabela mempool realizada com sucesso!";
} catch (PDOException $e) {
    // Desfaz a transação em caso de erro
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }

    // Mensagem de erro
    echo "Erro ao inserir na tabela mempool: " . $e->getMessage();
}





// xxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
// tratar dados de fichas pendentes? nem eu entendi.....?
// Verifica se há ordens de compra disponíveis
if (count($ordens_compra) > 0) {
    // Processa as transações e calcula as quantidades pendentes
    $fichas_restantes = $quantidade;
    $transacoes = [];
    $ordens_pendentes = [];

    foreach ($ordens_compra as $ordem) {
        if ($fichas_restantes <= 0) {
            break;
        }

        $quantidade_ordem = (int)$ordem['quantidade'];
        $quantidade_vendida = min($quantidade_ordem, $fichas_restantes);

        $transacoes[] = [
            'id_ordem' => $ordem['id'],
            'quantidade' => $quantidade_vendida,
            'valor' => $ordem['valor'],
            'user' => $ordem['user']
        ];

        $fichas_restantes -= $quantidade_vendida;

        // Calcula a quantidade pendente
        $quantidade_pendente = $quantidade_ordem - $quantidade_vendida;

        // Se houver quantidade pendente, armazena para reinserção
        if ($quantidade_pendente > 0) {
            $ordens_pendentes[] = [
                'id_ordem' => $ordem['id'],
                'quantidade_pendente' => $quantidade_pendente,
                'valor' => $ordem['valor'],
                'user' => $ordem['user']
            ];
        }
    }





// xxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    // Apaga as ordens de compra transacionadas
    try {
        foreach ($transacoes as $transacao) {
            $stmt = $pdo->prepare("DELETE FROM ordens_compra WHERE id = ?");
            $stmt->execute([$transacao['id_ordem']]);
        }
        error_log("Ordens de compra transacionadas apagadas com sucesso!");
    } catch (PDOException $e) {
        error_log("Erro ao apagar ordens de compra: " . $e->getMessage());
    }

    // Reinsere as ordens com quantidades pendentes
    try {
        foreach ($ordens_pendentes as $ordem_pendente) {
            $stmt = $pdo->prepare("
                INSERT INTO ordens_compra (quantidade, valor, user, dataehora)
                VALUES (:quantidade, :valor, :user, NOW())
            ");
            $stmt->execute([
                ':quantidade' => $ordem_pendente['quantidade_pendente'],
                ':valor' => $ordem_pendente['valor'],
                ':user' => $ordem_pendente['user']
            ]);
        }
        error_log("Ordens de compra com quantidades pendentes reinseridas com sucesso!");
    } catch (PDOException $e) {
        error_log("Erro ao reinserir ordens de compra pendentes: " . $e->getMessage());
    }
}





// xxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
// Inserir os dados na tabela venda
// Verifica se há transações para processar
if (!empty($transacoes)) {
    foreach ($transacoes as $transacao) {
        // Define as variáveis dentro do loop
        $quantidade_transacionada = $transacao['quantidade']; // Quantidade de fichas transacionadas
        $comprador = $transacao['user']; // Usuário que comprou as fichas
        $dataehora = date('Y-m-d H:i:s'); // Data e hora atual
 $valor_transacao = $transacao['valor'];
        // Insere os dados na tabela vendas
        $query = "
            INSERT INTO vendas (quantidade, preco, dataehora, vendedor, comprador, mediacao)
            VALUES (:quantidade, :preco, :dataehora, :vendedor, :comprador, :mediacao)
        ";

        $params = [
            ':quantidade' => $quantidade_transacionada, // Quantidade de fichas transacionadas
            ':preco' => $valor_transacao, // Preço unitário das fichas
            ':dataehora' => $dataehora, // Data e hora da transação
            ':vendedor' => $_SESSION['user_name'], // Vendedor (usuário logado)
            ':comprador' => $comprador, // Comprador (usuário da ordem de compra)
            ':mediacao' => 'Ordem de Compra' // Tipo de mediação
        ];

        try {
            $stmt = $pdo->prepare($query);
            $stmt->execute($params);
            error_log("Venda registrada para o comprador $comprador: $quantidade_transacionada fichas.");
        } catch (PDOException $e) {
            error_log("Erro ao registrar venda para o comprador $comprador: " . $e->getMessage());
        }
    }
} else {
    error_log("Nenhuma transação encontrada para registrar vendas.");
}

// xxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    // aTUALIZAR FICHAS PARA MUDAR Dono para o comprador, caso seja comprada em ordem de compra
try {
    // Verifica se há transações concluídas
    var_dump($transacoes);
    if (!empty($transacoes)) {
        foreach ($transacoes as $transacao) {
            $user_comprador = $transacao['user']; // Usuário que comprou as fichas
            $quantidade_vendida = $transacao['quantidade']; // Quantidade de fichas vendidas
$jogador_logado = $_SESSION['user_name'];
            // Atualiza a tabela fichaspersonagens
            $sql_update_fichas = "
                UPDATE fichaspersonagens 
                SET jogador = ?, preco = ?
                WHERE jogador = ? AND situacao = '1' 
                LIMIT $quantidade_vendida
            ";
            $stmt_update_fichas = $pdo->prepare($sql_update_fichas);
            $stmt_update_fichas->execute([$user_comprador, $transacao['valor'], $jogador_logado]);

            // Log para depuração
            error_log("Fichas atualizadas para o usuário $user_comprador: $quantidade_vendida fichas");
        }
    } else {
        error_log("Nenhuma transação concluída para atualizar fichas.");
    }
} catch (PDOException $e) {
    error_log("Erro ao atualizar fichas: " . $e->getMessage());
    $_SESSION['msg'] = "Erro ao atualizar fichas: " . $e->getMessage();
    header("Location: vender_fichas.php");
    exit();
}



// xxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
                // MENSAGENS 
// Inicializa a variável $msgfinal
$msgfinal = '';

// Verifica se houve transações realizadas
if (!empty($transacoes)) {
    $msgfinal .= "<h4>Transações Realizadas:</h4>";
    $msgfinal .= "<table border='1'>";
    $msgfinal .= "<tr>
                    <th>ID da Ordem</th>
                    <th>Quantidade Vendida</th>
                    <th>Valor Unitário (R$)</th>
                    <th>Total Obtido (R$)</th>
                    <th>Usuário Comprador</th>
                  </tr>";

    $total_ganho = 0; // Variável para armazenar o valor total ganho

    // Itera sobre as transações para construir o relatório
    foreach ($transacoes as $transacao) {
        $total_obtido = $transacao['quantidade'] * $transacao['valor'];
        $total_ganho += $total_obtido;

        $msgfinal .= "<tr>";
        $msgfinal .= "<td>" . htmlspecialchars($transacao['id_ordem']) . "</td>";
        $msgfinal .= "<td>" . htmlspecialchars($transacao['quantidade']) . "</td>";
        $msgfinal .= "<td>" . htmlspecialchars($transacao['valor']) . "</td>";
        $msgfinal .= "<td>" . htmlspecialchars(number_format($total_obtido, 2, ',', '.')) . "</td>";
        $msgfinal .= "<td>" . htmlspecialchars($transacao['user']) . "</td>";
        $msgfinal .= "</tr>";
    }

    $msgfinal .= "</table>";
    $msgfinal .= "<p><strong>Total Ganho:</strong> R$ " . number_format($total_ganho, 2, ',', '.') . "</p>";
} else {
    $msgfinal .= "<p>Nenhuma transação foi realizada.</p>";
}

// Verifica se sobrou alguma quantidade de fichas
if ($fichas_restantes > 0) {
    $msgfinal .= "<h4>Fichas que Sobraram:</h4>";
    $msgfinal .= "<p>Sobraram $fichas_restantes ficha(s) que foram listadas para venda.</p>";
} else {
    $msgfinal .= "<p>Todas as fichas foram vendidas.</p>";
}




// xxxxxxxxxxxxxxxxxxxxxxxxxxxx     xxxxxxxxxxxxxxxxxxxx
// Texto para mandar pro sistema
$txt1 = "O usuário $jogador_logado executou a venda de $quantidade fichas.";

// Verifica se houve ordens de compra compatíveis
if (!empty($transacoes)) {
    $quantidade_vendida_ordens = 0;
    $total_ganho = 0;
    $txt3 = "";

    // Itera sobre as transações para calcular totais e montar o texto
    foreach ($transacoes as $transacao) {
        $quantidade_vendida_ordens += $transacao['quantidade'];
        $total_ganho += $transacao['quantidade'] * $transacao['valor'];
        $txt3 .= "Foram vendidas {$transacao['quantidade']} fichas para a ordem de id {$transacao['id_ordem']}, do usuário {$transacao['user']}, no valor R$ {$transacao['valor']}; ";
    }

    $txt2 = "Dessa $quantidade ficha/s, $quantidade_vendida_ordens foram vendidas para ordens de compra.";
    $txt4 = "Totalizando um valor de R$ " . number_format($total_ganho, 2, ',', '.') . " vendido para as ordens.";
} else {
    $txt2 = "Nenhuma ficha foi vendida para ordens de compra.";
    $txt3 = "";
    $txt4 = "";
}

// Verifica se sobrou fichas
if ($fichas_restantes > 0) {
    $txt5 = "Sobrou $fichas_restantes ficha/s, essa/s que foi/foram listada/s para venda.";
} else {
    $txt5 = "Não sobrou fichas, todas foram vendidas para as ordens de compra.";
}

// Adiciona o ID da transação na mempool (supondo que $id_transacao_mempool seja o ID gerado)
$txt6 = "O valor foi inserido na mempool, na transação de id $id_transacao_mempool.";

// Monta o texto final
$txtfinal = "$txt1 $txt2 $txt3 $txt4 $txt5 $txt6";

// Exibe o texto final
echo $txtfinal;
echo "<br><Br>";
// Supondo que $txtfinal e $usuario_logado já estejam definidos
$usuario_logado = $_SESSION['user_name']; // Exemplo de como pegar o usuário logado

// Data e hora atual no formato DATETIME do MySQL
$dataehora = date('Y-m-d H:i:s');

// Query para inserir os dados na tabela infossistema
$query = "
    INSERT INTO infossistema (informacao, p1, origem, dataehora)
    VALUES (:informacao, :p1, :origem, :dataehora)
";

// Parâmetros para a query
$params = [
    ':informacao' => $txtfinal, // Texto final gerado
    ':p1' => $usuario_logado,   // Usuário logado
    ':origem' => 'venda de ficha/ Ordem de compra', // Origem da informação
    ':dataehora' => $dataehora  // Data e hora atual
];

// Prepara e executa a query
try {
    $stmt = $pdo->prepare($query);
    $stmt->execute($params);

    echo "Informação inserida com sucesso na tabela infossistema!";
} catch (PDOException $e) {
    echo "Erro ao inserir informação: " . $e->getMessage();
}


echo "<br><Br>";


// xxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
 // Texto da notificação
 $quantidade_transacionada = 1;

 $valor_ordem = 2;
    $notificacao = "$quantidade_transacionada Fichas compradas através da sua ordem de compra, no valor de R$ $valor_ordem na data $dataehora.";
echo $notificacao;
echo "<br><Br>";
        // Redireciona o usuário de volta para a página de venda de fichas
        // header("Location: vender_fichas.php");
        // Encerra a execução do script
    
    }
} catch (PDOException $e) {
    // Log de erro: exibe a mensagem de erro no arquivo de log
    error_log("Erro ao verificar ordens de compra: " . $e->getMessage());
    // Define uma mensagem de erro na sessão
    $_SESSION['msg'] = "Erro ao verificar ordens de compra.";
    // Redireciona o usuário de volta para a página de venda de fichas
    header("Location: vender_fichas.php");
    // Encerra a execução do script
    exit();
}




// xxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
// NOTIFICAÇÃO

// Verifica se há transações para processar

if (!empty($transacoes)) {
  echo "<br><br>";
    foreach ($transacoes as $transacao) {
        
        // Define as variáveis dentro do loop
        $quantidade_transacionada = $transacao['quantidade']; // Quantidade de fichas transacionadas
        $valor_ordem = $transacao['valor']; // Valor da ordem de compra
        $dataehora = date('Y-m-d H:i:s'); // Data e hora atual

        // Texto da notificação
        $notificacao = "$quantidade_transacionada Ficha/s comprada/s pela sua ordem de compra, no valor de R$ $valor_ordem na data de $dataehora.";

        // Insere a notificação na tabela notificacoes_sis
        $query = "
            INSERT INTO notificacoes_sis (tipo, notificacao, user1, user2, dataehora, vz1, vz2, apg)
            VALUES (:tipo, :notificacao, :user2, :user1, :dataehora, :vz1, :vz2, :apg)
        ";

        $params = [
            ':tipo' => 'Fichas compradas através de ordem de compra', // Tipo da notificação
            ':notificacao' => $notificacao, // Texto da notificação
            ':user1' => $transacao['user'], // Usuário que vai receber a notificação (user da ordem de compra)
            ':user2' => $_SESSION['user_name'], // Usuário envolvido (usuário logado)
            ':dataehora' => $dataehora, // Data e hora da notificação
            ':vz1' => 0, // vz1 deve ser 0
            ':vz2' => 0, // vz2 deve ser 0
            ':apg' => 0  // apg deve ser 0
        ];

        try {
            $stmt = $pdo->prepare($query);
            $stmt->execute($params);
            error_log("Notificação enviada para o usuário {$transacao['user']}: $notificacao");
        } catch (PDOException $e) {
            error_log("Erro ao enviar notificação para o usuário {$transacao['user']}: " . $e->getMessage());
        }
    }
} else {
    error_log("Nenhuma transação encontrada para enviar notificações.");
}




// xxxxxxxxxxxxxxxxxxxxxxx    xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        // Altera a situação das fichas pra vendendo
        $stmt = $pdo->prepare("INSERT INTO vendadefichas (quantidade, jogador, preco, datacriacao) VALUES (?, ?, ?, NOW())");
        $stmt->execute([$quantidade, $jogador, $preco]);



try {
    $jogadorx = $user_name; // Substitua pelo valor correto
    $quantidade = $quantidade; // Substitua pelo valor correto

     $sql = "UPDATE fichaspersonagens SET situacao = 'vendendo', preco = ? WHERE jogador = ? AND situacao = '1' LIMIT ?";
    $stmt = $pdo->prepare($sql);

    // Passa os valores para a consulta
    $stmt->bindValue(1, $preco, PDO::PARAM_STR); // Preço
    $stmt->bindValue(2, $jogadorx, PDO::PARAM_STR); // Jogador
    $stmt->bindValue(3, $quantidade, PDO::PARAM_INT); // Quantidade

 // Executa a consulta
    $stmt->execute(); // <--- AQUI ESTÁ O execute() QUE FALTAVA

    echo "Atualização das fichas realizada com sucesso!";
} catch (PDOException $e) {
    echo "Erro: " . $e->getMessage();
}

 
// xxxxxxxxxxxxxxxxxxx   xxxxxxxxxxxxxxxxxxxxx
// Exibe a mensagem final
// Texto explicativo ´para o usuario
$txt1 = "Você executou a venda de $quantidade fichas.";

// Verifica se houve ordens de compra compatíveis
if (!empty($transacoes)) {
    $quantidade_vendida_ordens = 0;
    $total_ganho = 0;
    $txt3 = "";

    // Itera sobre as transações para calcular totais e montar o texto
    foreach ($transacoes as $transacao) {
        $quantidade_vendida_ordens += $transacao['quantidade'];
        $total_ganho += $transacao['quantidade'] * $transacao['valor'];
        $txt3 .= "Foram vendida/s {$transacao['quantidade']} ficha/s para uma ordem no valor R$ {$transacao['valor']}; ";
    }

    $txt2 = "Dessas $quantidade fichas, $quantidade_vendida_ordens foram vendidas para um ou mais ordens de compra.";
    $txt4 = "Totalizando um valor de R$ " . number_format($total_ganho, 2, ',', '.') . " vendido para as ordens de compra.";
} else {
    $txt2 = "Não tinha nenhuma ordem de compra compatível com o valor de venda. Então suas fichas foram listadas para venda.";
    $txt3 = "";
    $txt4 = "";
}

// Verifica se sobrou fichas
if ($fichas_restantes > 0) {
    $txt5 = "Sobrou $fichas_restantes fichas, essas que foram listadas para venda.";
} else {
  //  $txt5 = "Não sobrou fichas, todas foram vendidas para as ordens de compra.";
}

// Monta o texto final
$txtpusuario = "$txt1 $txt2 $txt3 $txt4 $txt5";
echo "<br><Br>";
// Exibe o texto final
echo $txtpusuario;
echo "<br><Br>";
// $_SESSION['msg2'] = $txtpusuario;


$_SESSION['msg'] = "$txt1 $txt2 $txt3 $txt4 $txt5";



if (!$pdo->inTransaction()) { // Garante que a transação só começa se não estiver ativa
        $pdo->beginTransaction();
    }

        // Atualiza a situação das fichas para 'vendendo'
        $sql = "UPDATE fichaspersonagens SET situacao = 'vendendo', preco = ? WHERE jogador = ? AND situacao = '1' LIMIT ?";
        error_log("Executando SQL: $sql");
        error_log("Jogador: $jogador, Quantidade: $quantidade");

        $stmt = $pdo->prepare($sql);
         $stmt->bindValue(1, $preco, PDO::PARAM_STR); // Preço
    $stmt->bindValue(2, $jogadorx, PDO::PARAM_STR); // Jogador
    $stmt->bindValue(3, $quantidade, PDO::PARAM_INT); // Quantidade
        $stmt->execute();

        $pdo->commit();

      //  $_SESSION['msg'] = "$quantidade fichas listadas para venda, por R$ $preco";
        header("Location: vender_fichas.php");

        exit();
    } catch (PDOException $e) {
        $pdo->rollBack();
        error_log("Erro ao processar a venda: " . $e->getMessage());
        $_SESSION['msg'] = "Erro ao processar a venda: " . $e->getMessage();
        header("Location: vender_fichas.php");
        exit();
    }







   
}

?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Vender Fichas</title>
    <link rel="stylesheet" type="text/css" href="../style.css">
    <script>
        function formatCurrency(input) {
            // Remove todos os caracteres não numéricos
            let value = input.value.replace(/\D/g, '');

            // Garante que o valor tenha pelo menos 2 dígitos (para os centavos)
            if (value.length === 0) {
                value = '000'; // Inicia com "0.00"
            } else if (value.length === 1) {
                value = '00' + value; // Adiciona dois zeros à esquerda
            } else if (value.length === 2) {
                value = '0' + value; // Adiciona um zero à esquerda
            }

            // Separa a parte inteira dos centavos
            const integerPart = value.slice(0, -2); // Parte inteira
            const decimalPart = value.slice(-2); // Centavos

            // Formata o valor como "X.XX" ou "XX.XX", etc.
            input.value = `${integerPart}.${decimalPart}`;
        }

        function confirmarVenda() {
            return confirm("Tem certeza que deseja vender essas fichas?");
        }
    </script>
</head>
<body>
    <div class="titulo">Vender Fichas</div>
    <center>
        <?php
        if (isset($_SESSION['msg'])) {
            echo '<p class="mensagem">' . $_SESSION['msg'] . '</p>';
            unset($_SESSION['msg']);
        }
        ?>
    </center>
    <form method="POST" onsubmit="return confirmarVenda()">
        <input type="number" class="inputpadrao" id="quantidade" name="quantidade" placeholder="Quantidade de Fichas" required min="1">
        <br><br>
        <input type="text" class="inputpadrao" id="moneyInput" name="preco" placeholder="Preço (ex: 0.00)" required oninput="formatCurrency(this)">
        <br><br>
        <button type="submit" class="btn">Vender Fichas</button>
    </form>
</body>
</html>

<script>
    const moneyInput1 = document.getElementById("moneyInput");
    const moneyInput2 = document.getElementById("moneyInput2");
    const moneyInput3 = document.getElementById("moneyInput3");

    moneyInput1.addEventListener("input", function() {
      let inputValue = moneyInput1.value;

      // Resto do seu código para moneyInput1
      inputValue = inputValue.replace(/[^0-9]/g, '');
      while (inputValue.length < 2) {
        inputValue = '0' + inputValue;
      }
      const integerPart = parseInt(inputValue.slice(0, -2)) || 0;
      const decimalPart = inputValue.slice(-2);
      const formattedValue = `${integerPart}.${decimalPart}`;
      moneyInput1.value = formattedValue;
    });


moneyInput3.addEventListener("input", function() {
      let inputValue = moneyInput3.value;

      // Resto do seu código para moneyInput3
      inputValue = inputValue.replace(/[^0-9]/g, '');
      while (inputValue.length < 2) {
        inputValue = '0' + inputValue;
      }
      const integerPart = parseInt(inputValue.slice(0, -2)) || 0;
      const decimalPart = inputValue.slice(-2);
      const formattedValue = `${integerPart}.${decimalPart}`;
      moneyInput3.value = formattedValue;
    });

    moneyInput2.addEventListener("input", function() {
      let inputValue = moneyInput2.value;

      // Resto do seu código para moneyInput2
      inputValue = inputValue.replace(/[^0-9]/g, '');
      while (inputValue.length < 2) {
        inputValue = '0' + inputValue;
      }
      const integerPart = parseInt(inputValue.slice(0, -2)) || 0;
      const decimalPart = inputValue.slice(-2);
      const formattedValue = `${integerPart}.${decimalPart}`;
      moneyInput2.value = formattedValue;
    });

    
  </script>